USE [GENISIS_DB]
GO
/****** Object:  Table [dbo].[CommentHistory]   ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[CommentHistory](
	[CommentId] [int] NOT NULL,
	[RequestId] [int] NOT NULL,
	[StatusId] [int] NOT NULL,
	[Comments] [varchar](3000) NULL,
	[CreatedOn] [datetime] NULL,
	[CreatedBy] [varchar](50) NULL,
	[TYPE] [varchar](6) NULL,
	[TaskId] [varchar](50) NULL,
 CONSTRAINT [PK_CommentHistory] PRIMARY KEY CLUSTERED 
(
	[CommentId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[Management_table]     ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[Management_table](
	[ReqID] [int] NULL,
	[DatabaseName] [varchar](50) NULL,
	[CopyStatus] [varchar](25) NULL,
	[dateandtime] [datetime] NULL,
	[checksum_before_copy] [bigint] NULL,
	[checksum_after_copy] [bigint] NULL,
	[Table_Name] [varchar](50) NULL,
	[rowcount_before_copy] [int] NULL,
	[rowcount_after_copy] [int] NULL,
	[status_before_copy] [varchar](20) NULL,
	[status_after_copy] [varchar](20) NULL
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[Request]  ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[Request](
	[Id] [int] NOT NULL,
	[ProcessId] [int] NOT NULL,
	[Title] [varchar](256) NULL,
	[Description] [varchar](3000) NULL,
	[ApprovalStatus] [varchar](50) NULL,
	[DetailesInternalStatusCode] [varchar](50) NULL,
	[StatusDescription] [varchar](50) NULL,
	[RequestType] [int] NOT NULL,
	[Source] [int] NOT NULL,
	[NotifyCollaboraters] [tinyint] NULL,
	[AssociatedRequest1] [int] NULL,
	[AssociatedRequest2] [int] NULL,
	[AssociatedRequest3] [int] NULL,
	[StudyApproval] [int] NOT NULL,
	[CreatedOn] [datetime] NULL,
	[ModifiedOn] [datetime] NULL,
	[CreatedBy] [varchar](50) NULL,
	[ModifiedBy] [varchar](50) NULL,
	[ApproverId] [varchar](50) NULL,
	[TaskId] [varchar](50) NULL,
 CONSTRAINT [PK_Request] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[RequestHistory]    Script Date: 5/11/2017 4:22:33 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[RequestHistory](
	[HistLineNo] [int] NOT NULL,
	[Id] [int] NOT NULL,
	[ProcessId] [int] NOT NULL,
	[Title] [varchar](256) NULL,
	[Description] [varchar](3000) NULL,
	[ApprovalStatus] [varchar](50) NULL,
	[DetailesInternalStatusCode] [varchar](50) NULL,
	[StatusDescription] [varchar](50) NULL,
	[RequestType] [int] NOT NULL,
	[Source] [int] NOT NULL,
	[NotifyCollaboraters] [tinyint] NULL,
	[AssociatedRequest1] [int] NULL,
	[AssociatedRequest2] [int] NULL,
	[AssociatedRequest3] [int] NULL,
	[StudyApproval] [int] NOT NULL,
	[CreatedOn] [datetime] NULL,
	[ModifiedOn] [datetime] NULL,
	[CreatedBy] [varchar](50) NULL,
	[ModifiedBy] [varchar](50) NULL,
	[ApproverId] [varchar](50) NULL,
	[TaskId] [varchar](50) NULL,
 CONSTRAINT [PK_RequestHistory] PRIMARY KEY CLUSTERED 
(
	[HistLineNo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[RequestType]  ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[RequestType](
	[Id] [int] NOT NULL,
	[Description] [varchar](50) NULL,
 CONSTRAINT [PK_RequestType] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[Role_Type]   ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[Role_Type](
	[Role_Type_id] [int] NOT NULL,
	[Role_Name] [varchar](50) NOT NULL,
	[Role_Description] [varchar](50) NOT NULL,
 CONSTRAINT [Role_Type_pk] PRIMARY KEY CLUSTERED 
(
	[Role_Type_id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[Source]   ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[Source](
	[Id] [int] NOT NULL,
	[Description] [varchar](50) NULL,
 CONSTRAINT [PK_Source] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[StudyApproval]    Script Date: 5/11/2017 4:22:33 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[StudyApproval](
	[Id] [int] NOT NULL,
	[ProcessId] [int] NOT NULL,
	[ApprovalIdObtained] [varchar](3000) NULL,
	[AssociatedStudyApproval1] [int] NULL,
	[AssociatedStudyApproval2] [int] NULL,
	[AssociatedStudyApproval3] [int] NULL,
	[Title] [varchar](50) NULL,
	[Description] [varchar](3000) NULL,
	[CreatedOn] [datetime] NULL,
	[ModifiedOn] [datetime] NULL,
	[CreatedBy] [varchar](50) NULL,
	[ModifiedBy] [varchar](50) NULL,
 CONSTRAINT [PK_StudyApproval] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[User_Approver]     ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[User_Approver](
	[Id] [int] NOT NULL,
	[User_id] [varchar](320) NOT NULL,
	[User_Approver_id] [varchar](320) NOT NULL,
 CONSTRAINT [User_Approver_pk] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[User_Role_Type]  ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[User_Role_Type](
	[Id] [int] NOT NULL,
	[Role_Type_id] [int] NOT NULL,
	[User_Type_id] [int] NOT NULL,
	[User_id] [varchar](320) NOT NULL,
	[Start_Date] [datetime] NOT NULL,
	[End_Date] [datetime] NULL,
 CONSTRAINT [User_Role_Type_pk] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[User_Type]    ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[User_Type](
	[User_Type_id] [int] NOT NULL,
	[User_Type_desc] [varchar](50) NOT NULL,
 CONSTRAINT [User_Type_pk] PRIMARY KEY CLUSTERED 
(
	[User_Type_id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[Users]    ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[Users](
	[User_id] [varchar](320) NOT NULL,
	[First_Name] [varchar](50) NOT NULL,
	[Middle_Name] [varchar](50) NULL,
	[Last_Name] [varchar](50) NOT NULL,
	[Last_Name2] [varchar](50) NULL,
	[Create_Date] [datetime] NOT NULL,
	[Email_id] [varchar](320) NOT NULL,
	[User_Active] [tinyint] NOT NULL,
	[Active_date] [datetime] NOT NULL,
	[Inactive_date] [datetime] NULL,
 CONSTRAINT [User_pk] PRIMARY KEY CLUSTERED 
(
	[User_id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[WorkflowStatus]   ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[WorkflowStatus](
	[Id] [int] NOT NULL,
	[Description] [varchar](50) NULL,
 CONSTRAINT [PK_WorkflowStatus] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO







---FOREIGNKEYS SCRIPTS FOR THE DATABASE

ALTER TABLE [dbo].[CommentHistory]  WITH CHECK ADD  CONSTRAINT [FK_CommentHistory_Request] FOREIGN KEY([RequestId])
REFERENCES [dbo].[Request] ([Id])
GO
ALTER TABLE [dbo].[CommentHistory] CHECK CONSTRAINT [FK_CommentHistory_Request]
GO
ALTER TABLE [dbo].[CommentHistory]  WITH CHECK ADD  CONSTRAINT [FK_CommentHistory_WorkflowStatus] FOREIGN KEY([StatusId])
REFERENCES [dbo].[WorkflowStatus] ([Id])
GO
ALTER TABLE [dbo].[CommentHistory] CHECK CONSTRAINT [FK_CommentHistory_WorkflowStatus]
GO
ALTER TABLE [dbo].[RequestHistory]  WITH CHECK ADD  CONSTRAINT [FK_RequestHistory_Request] FOREIGN KEY([Id])
REFERENCES [dbo].[Request] ([Id])
GO
ALTER TABLE [dbo].[RequestHistory] CHECK CONSTRAINT [FK_RequestHistory_Request]
GO
ALTER TABLE [dbo].[User_Approver]  WITH CHECK ADD  CONSTRAINT [User_Approver_User] FOREIGN KEY([User_id])
REFERENCES [dbo].[Users] ([User_id])
GO
ALTER TABLE [dbo].[User_Approver] CHECK CONSTRAINT [User_Approver_User]
GO
ALTER TABLE [dbo].[User_Approver]  WITH CHECK ADD  CONSTRAINT [User_Approver_User_id] FOREIGN KEY([User_Approver_id])
REFERENCES [dbo].[Users] ([User_id])
GO
ALTER TABLE [dbo].[User_Approver] CHECK CONSTRAINT [User_Approver_User_id]
GO
ALTER TABLE [dbo].[User_Role_Type]  WITH CHECK ADD  CONSTRAINT [FK_Type_User] FOREIGN KEY([User_id])
REFERENCES [dbo].[Users] ([User_id])
GO
ALTER TABLE [dbo].[User_Role_Type] CHECK CONSTRAINT [FK_Type_User]
GO
ALTER TABLE [dbo].[User_Role_Type]  WITH CHECK ADD  CONSTRAINT [FK_User_typeID] FOREIGN KEY([User_Type_id])
REFERENCES [dbo].[User_Type] ([User_Type_id])
GO
ALTER TABLE [dbo].[User_Role_Type] CHECK CONSTRAINT [FK_User_typeID]
GO
ALTER TABLE [dbo].[User_Role_Type]  WITH CHECK ADD  CONSTRAINT [User_Role_Type_Role_Type] FOREIGN KEY([Role_Type_id])
REFERENCES [dbo].[Role_Type] ([Role_Type_id])
GO
ALTER TABLE [dbo].[User_Role_Type] CHECK CONSTRAINT [User_Role_Type_Role_Type]
GO
